//Experiment-4
// windows Vista - 32-Bit
//Scilab - 5.5.2


// Aim : Finding voltage regulation and efficiency of a medium  transmission line using nominal PI method through SCILAB

mode(0);

clc 
clear all
disp('Nominal PI Method for medium transmission line') 
R = input('Enter the Total line Resistance in Ohms : ');  // Total Line Resistance in Ohms like 10 Ohms
XL = input('Enter the Total line Inductive Reactance in Ohms : '); // Total line Inductive Reactance in Ohms like 50 Ohms
Y = input('Enter the Total line Suseptance in Seimen : '); // Total line Suseptance in Seimen like 10e-4 Seimen
f = input('Enter the Frequency in Hz: '); // Frequency in Hz like 50 Hz
PR= input('Enter the Recieving End Power in Watt : '); // Recieving End Power in Volt like 20e6 W
VRLL= input('Enter the Recieving End Line Voltage in Volt :'); // Recieving End Line Voltage in Volt like 66e3 V
pf= input('Enter Recievinf End Lagging Power Factor : '); // Recievinf End Lagging Power Factor like 0.9
Z=R+%i*XL;
VR = VRLL/sqrt(3);

IR=PR/(sqrt(3)*VRLL*pf);
IR_COMPLEX=IR*(cos(acos(pf))-%i*sin(acos(pf)));

IC1=%i*Y/2*VR;

IL = IR_COMPLEX + IC1;

VS = VR + IL*Z;

IC2 = %i*Y/2*VS;

IS=IL + IC2

[VS_abs,Phase_VS]= polar(VS);
[IS_abs,Phase_IS]= polar(IS);
VS_abs;
IS_abs;
VSLL=VS*sqrt(3);
VSLL_abs=abs(VSLL)/1000
PHASE_DIFF=Phase_VS-Phase_IS;
SendingEnd_PF=cos(PHASE_DIFF);

PS=3*abs(VS)*abs(IS)*cos(PHASE_DIFF)
EFF=(abs(PR)/abs(PS))*100
REG = 100*((abs (VSLL) - abs (VRLL)))/ abs (VRLL)

mprintf('Sendingend Current = %f A \n',IS_abs)
mprintf('Sendingend Line Voltage = %f kV \n',VSLL_abs)
mprintf('Sendingend Power factor = %f \n',SendingEnd_PF)
mprintf('Efficiency = %f %% \n', EFF)
mprintf('Regulation = %f %% \n', REG)


//output:-
//
//Nominal PI Method for medium transmission line   
//Enter the Total line Resistance in Ohms : 10
//Enter the Total line Inductive Reactance in Ohms : 50
//Enter the Total line Suseptance in Seimen : 10e-4
//Enter the Frequency in Hz: 50
//Enter the Recieving End Power in Watt : 20e6
//Enter the Recieving End Line Voltage in Volt :66e3
//Enter Recievinf End Lagging Power Factor : 0.9
// IS  =
// 
//    170.90917 - 44.112456i  
// VSLL_abs  =
// 
//    76.021348  
// PS  =
// 
//    21047697. + 1.094D-09i  
// EFF  =
// 
//    95.022274  
// REG  =
// 
//    15.183861  
//Sendingend Current = 176.510208 A 
//Sendingend Line Voltage = 76.021348 kV 
//Sendingend Power factor = 0.905604 
//Efficiency = 95.022274 % 
//Regulation = 15.183861 % 
